class FocusManager {
  constructor(editor, autoFocus) {
    this.editor = editor;
    this.disposeSideEffectListener = editor.sideEffects.registerAfterChangeHandler(
      "instance",
      (prev, next) => {
        if (prev.isFocused !== next.isFocused) {
          next.isFocused ? this.focus() : this.blur();
          this.updateContainerClass();
        }
      }
    );
    const currentFocusState = editor.getInstanceState().isFocused;
    if (autoFocus !== currentFocusState) {
      editor.updateInstanceState({ isFocused: !!autoFocus });
    }
    this.updateContainerClass();
  }
  disposeSideEffectListener;
  /**
   * The editor's focus state and the container's focus state
   * are not necessarily always in sync. For that reason we
   * can't rely on the css `:focus` or `:focus-within` selectors to style the
   * editor when it is in focus.
   *
   * For that reason we synchronize the editor's focus state with a
   * special class on the container: tl-container__focused
   */
  updateContainerClass() {
    const container = this.editor.getContainer();
    const instanceState = this.editor.getInstanceState();
    if (instanceState.isFocused) {
      container.classList.add("tl-container__focused");
    } else {
      container.classList.remove("tl-container__focused");
    }
  }
  focus() {
    this.editor.getContainer().focus();
  }
  blur() {
    this.editor.complete();
    this.editor.getContainer().blur();
  }
  dispose() {
    this.disposeSideEffectListener?.();
  }
}
export {
  FocusManager
};
//# sourceMappingURL=FocusManager.mjs.map
